<?php
if ( ! class_exists('tipax_shipping_orders_common') ) {
    class tipax_shipping_orders_common {
        private static $hpos_enabled = null;
        function is_wc_hpos_enabled() {
            if ( is_null(self::$hpos_enabled) ) {
                if ( class_exists('Automattic\WooCommerce\Utilities\OrderUtil') ) {
                    self::$hpos_enabled = Automattic\WooCommerce\Utilities\OrderUtil::custom_orders_table_usage_is_enabled();
                } else {
                    self::$hpos_enabled = false;
                }
            }
            return self::$hpos_enabled;
        }
    }
}

function tipax_barcode_order_meta_box() {
    $instance = new tipax_shipping_orders_common();
    $screen = $instance->is_wc_hpos_enabled() ? wc_get_page_screen_id('shop-order') : 'shop_order';
    add_meta_box(
        'tipax-barcode-box',
        __('Tipax Barcodes','delivery-service-tipax-shipping'),
        'tipax_shipping_barcode_meta_box',
        $screen,
        'side',
        'default'
    );
}
add_action('add_meta_boxes', 'tipax_barcode_order_meta_box');

function tipax_shipping_barcode_meta_box($order) {
    $desired_shipping_method = 'tipax_shipping_method';

    // Normalize WC_Order
    if (!is_a($order, 'WC_Order')) {
        if (isset($order->ID)) {
            $order = wc_get_order($order->ID);
        } elseif (isset($_GET['post'])) {
            $order = wc_get_order(absint($_GET['post']));
        }
        if (!is_a($order, 'WC_Order')) {
            echo esc_html__('Order type is not WooCommerce.', 'delivery-service-tipax-shipping');
            return;
        }
    }

    // Ensure Tipax shipping
    $is_tipax = false;
    foreach ($order->get_shipping_methods() as $shipping_item) {
        if ($shipping_item->get_method_id() === $desired_shipping_method) {
            $is_tipax = true; break;
        }
    }
    if (!$is_tipax) {
        echo esc_html__('Tipax is not shipping method for this order.','delivery-service-tipax-shipping');
        return;
    }

    // Your working Picqer include
    require_once 'vendor/autoload.php';
    if (!class_exists('Picqer\\Barcode\\BarcodeGeneratorPNG')) {
        echo esc_html__('Barcode generator not found.','delivery-service-tipax-shipping');
        return;
    }

    $generator = new \Picqer\Barcode\BarcodeGeneratorPNG();

    // Collect barcodes and preview
    $has_barcode   = false;
    $barcode_data  = []; // [ [code => '...', img => 'data:...'], ... ]
    $preview_html  = '';

    foreach ($order->get_items() as $item) {
        $codes_raw = (string) $item->get_meta('tipax_tracking_code');
        if ($codes_raw === '') { continue; }
        $codes = preg_split('/\s+/', trim($codes_raw));
        if (empty($codes)) { continue; }

        foreach ($codes as $code) {
            $code = trim($code);
            if ($code === '') { continue; }
            $has_barcode = true;

            try {
                $png = $generator->getBarcode($code, $generator::TYPE_CODE_128, 2, 80);
                $img = 'data:image/png;base64,' . base64_encode($png);
            } catch (\Exception $e) {
                // Skip a faulty code
                continue;
            }

            $barcode_data[] = ['code' => $code, 'img' => $img];
            $preview_html  .= '<div style="margin-bottom:10px;text-align:center;">'
                            . '<img style="max-width:100%" src="' . esc_attr($img) . '" alt="' . esc_attr($code) . '"><br>'
                            . esc_html($code)
                            . '</div>';
        }
    }

    if (!$has_barcode) {
        echo esc_html__('There is no barcodes.','delivery-service-tipax-shipping');
        return;
    }

        $settings = get_option('woocommerce_tipax_shipping_method_settings', []);
        $show_products = ($settings['show_product_table'] ?? 'yes') === 'yes';
        $custom_logo_url = $settings['logo_url'] ?? '';
        $sender_phone = $settings['phone'] ?? '';
        $sender_name  = $settings['name'] ?? get_bloginfo('name');
        
        $custom_logo_url = $settings['logo_url'] ?? '';
    // Build order + party info for printing
    $order_data = [
        'order_id'   => $order->get_id(),
        'order_date' => $order->get_date_created() ? wc_format_datetime($order->get_date_created(), 'Y/m/d') : '',
        'products'   => array_values(array_map(function($it){
            return ['name' => $it->get_name(), 'qty' => (int)$it->get_quantity()];
        }, $order->get_items())),
        'sender' => [
            'name'     => get_bloginfo('name'),
            'phone'    => (string) ($sender_phone ?: ''),
            'address'  => trim((get_option('woocommerce_store_address') ?: '') . ' ' . (get_option('woocommerce_store_address_2') ?: '') . ', ' . (get_option('woocommerce_store_city') ?: '')),
            'postcode' => (string) get_option('woocommerce_store_postcode'),
            'display_products' => $show_products,
        ],
        'receiver' => [
            'name'     => trim(($order->get_shipping_first_name() ?: '') . ' ' . ($order->get_shipping_last_name() ?: '')),
            'phone'    => (string) $order->get_billing_phone(),
            'address'  => trim(($order->get_shipping_address_1() ?: '') . ' ' . ($order->get_shipping_address_2() ?: '')),
            'postcode' => (string) $order->get_shipping_postcode(),
        ],
        'barcodes' => $barcode_data,
'logo' => $custom_logo_url ?: (wp_get_attachment_image_url(get_theme_mod('custom_logo'),'full') ?: includes_url('images/w-logo-blue.png')),

        'font_url' => esc_url(plugins_url('../assets/BNazanin.TTF', __FILE__)), // optional
    ];

    // Render preview + Print button (use inline onclick; return false)
    echo '<div id="printable-content" style="text-align:center">' . $preview_html . '</div>';
    echo '<button type="button" class="button button-primary" style="margin-top:10px;" onclick="return tipax_print_label();">'
        . esc_html__('Print Barcodes', 'delivery-service-tipax-shipping') . '</button>';

    // Print function (global, inline, returns false to block form submit)
    ?>
    <script>
    (function(){
        // Data from PHP
        window._tipaxPrintData = <?php echo wp_json_encode($order_data); ?>;

        // Global print function used by inline onclick
        window.tipax_print_label = function(){
            try {
                var d = window._tipaxPrintData || {};
var css = ''
  + '@page { size: A5 portrait; margin: 0; }'
  + '@font-face { font-family: "BNazanin"; src: url("' + (d.font_url || '') + '") format("truetype"); }'
  + 'body{margin:0 auto;font-family:"BNazanin",Tahoma,sans-serif;direction:rtl;background:#fff;padding:0;}'
  + '.invoice{width:148mm;height:210mm;box-sizing:border-box;padding:6mm;border:1px solid #ccc;page-break-after:always;overflow:hidden;}'
  + 'header{display:flex;justify-content:space-between;align-items:center;border-bottom:1px solid #ccc;padding-bottom:2mm;margin-bottom:3mm;}'
  + 'header img{height:30px;}'
  + '.barcode{text-align:center;margin:5mm 0;}'
  + '.barcode img{height:55px;margin-bottom:1mm;}'
  + '.barcode p{font-size:15px;font-weight:bold;letter-spacing:1px;}'
  + '.info{display:flex;flex-direction:column;gap:4mm;margin-top:1mm;}'
  + '.info-box{width:calc(100% - 20px);border:1px solid #ddd;padding:3mm;border-radius:4px;background:#fafafa;}'
  + '.info-box h3{font-size:15px;margin:0 0 2mm;border-bottom:1px solid #ddd;padding-bottom:1mm;}'
  + '.info-box p{margin:0 0 1mm;font-size:14px;line-height:1.4;}'
  + 'table{width:100%;border-collapse:collapse;margin-top:3mm;font-size:14px;}'
  + 'th,td{border:2px solid #ccc;padding:2px 4px;text-align:center;}'
  + 'th{background:#f2f2f2;}'
  + '.barcode{font-family:Tahoma,sans-serif;}'
  + '@media print{.invoice{page-break-after:always;width:148mm;height:210mm;margin:0 auto;}}';


                var rows = '';
                (d.products||[]).forEach(function(p){
                    rows += '<tr><td>'+ esc(p.name) +'</td><td>'+ String(p.qty) +'</td></tr>';
                });
                
                var tableHTML = '';
                if (d.sender.display_products) {
                    tableHTML = '<table><thead><tr><th>نام محصول</th><th>تعداد</th></tr></thead><tbody>'+ rows +'</tbody></table>';
                }

                var blocks = '';
                (d.barcodes||[]).forEach(function(b){
                    var code = String(b.code||'');
                    var img  = String(b.img||'');
                    blocks += ''
                    + '<div class="invoice">'
                    + '  <header>'
                    + '    <img src="'+ escAttr(d.logo||'') +'" alt="لوگو">'
                    + '    <div><p>شماره فاکتور: '+ esc(String(d.order_id||'')) +'</p><p>تاریخ: '+ esc(String(d.order_date||'')) +'</p></div>'
                    + '  </header>'
                    + '  <div class="barcode">'
                    + '    <img src="'+ escAttr(img) +'" alt="barcode"><p class="barcode">'+ esc(code) +'</p>'
                    + '  </div>'
                    + '  <div class="info">'
                    + '    <div class="info-box">'
                    + '      <h3>فرستنده</h3>'
                    + '      <p>'+ esc(d.sender && d.sender.name || '') +'</p>'
                    + '      <p>تلفن: '+ esc(d.sender && d.sender.phone || '') +'</p>'
                    + '      <p>آدرس: '+ esc(d.sender && d.sender.address || '') +'</p>'
                    + '      <p>کدپستی: '+ esc(d.sender && d.sender.postcode || '') +'</p>'
                    + '    </div>'
                    + '    <div class="info-box">'
                    + '      <h3>گیرنده</h3>'
                    + '      <p>'+ esc(d.receiver && d.receiver.name || '') +'</p>'
                    + '      <p>تلفن: '+ esc(d.receiver && d.receiver.phone || '') +'</p>'
                    + '      <p>آدرس: '+ esc(d.receiver && d.receiver.address || '') +'</p>'
                    + '      <p>کدپستی: '+ esc(d.receiver && d.receiver.postcode || '') +'</p>'
                    + '    </div>'
                    + '  </div>'
                    + tableHTML
                    + '</div>';
                });

                var w = window.open('', '_blank');
                if (!w) { alert('Popup blocked. Please allow popups and try again.'); return false; }
                w.document.open();
                w.document.write('<html lang="fa"><head><meta charset="UTF-8"><title>چاپ برچسب تیپاکس</title><style>'+ css +'</style></head><body>'+ blocks +'</body></html>');
                w.document.close();
                w.onload = function(){ try { w.focus(); w.print(); w.close(); } catch(e){} };
            } catch(err) {
                console.error(err);
            }
            // block any default form submission
            return false;
        };

        // Safe HTML escaping helpers
        function esc(s){ s = String(s||''); return s.replace(/[&<>"]/g, function(m){return {'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;'}[m]}); }
        function escAttr(s){ return esc(s).replace(/"/g,'&quot;'); }
    })();
    </script>
    <?php
}
