<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class WC_Tipax_V2 {
    
    private $settings;
    private $request;
    
    public function __construct() {
        $this->request = new Request();  // Assuming Request class is available
        $this->settings = get_option( 'woocommerce_tipax_shipping_method_settings' );
        //check access token exists or no
        $accessToken = get_option('woocommerce_tipax_shipping_method_accesstoken', null);

        if (isset($accessToken) || $accessToken != null) {
            $this->accessToken = $accessToken;
        } else {
            $this->accessToken = null;
        }
    }

    public function checkApiKey($refreshToken = false)
    {
        $response_message = '';

        if ($refreshToken == true) {
            $data = [
                'username' => isset($this->settings["username"]) ? $this->settings["username"] : null,
                'password' => isset($this->settings["password"]) ? $this->settings["password"] : null,
                'apiKey' => isset($this->settings["apiKey"]) ? $this->settings["apiKey"] : null,
            ];
            $response = $this->request->apiRequest('Account/token', $data, "POST");

            if ($response) {
                $accessToken = $response->accessToken;
                update_option('woocommerce_tipax_shipping_method_accesstoken', $accessToken, '', 'yes');
                $response_message = 'Connection successful. Token saved.';
            }
        }

        if ((isset($this->settings['apiKey'])) && (isset($this->settings['username'])) && (isset($this->settings['password']))) {
            $data = [
                'username' => isset($this->settings["username"]) ? $this->settings["username"] : null,
                'password' => isset($this->settings["password"]) ? $this->settings["password"] : null,
                'apiKey' => isset($this->settings["apiKey"]) ? $this->settings["apiKey"] : null,
            ];

            if (isset($this->accessToken) && $this->accessToken != null) {
                $response_message = 'Connection successful. Access token already available.';
            } else {
                $response = $this->request->apiRequest('Account/token', $data, "POST");
                if (!isset($response->errors)) {
                    $accessToken = isset($response->accessToken) ? $response->accessToken : null;

                    if ($accessToken != null) {
                        $this->accessToken = $accessToken;
                        update_option('woocommerce_tipax_shipping_method_accesstoken', $accessToken, '', 'yes');
                        $response_message = 'Connection successful. Token refreshed.';
                    } else {
                        $response_message = 'Failed to retrieve access token.';
                    }
                } else {
                    $response_message = isset($response->message) ? $response->message : 'Unknown error occurred.';
                }
            }
        } else {
            $response_message = 'Missing credentials: Please check your username, password, and API key.';
        }

        return $response_message;
    }
    
    public function loadAddresses()
    {
        $controlCall = 0;
        if (get_transient('addresses_loaded')) {
            $controlCall = 1;
        }
        if (!$controlCall) {
            // set_transient('addresses_loaded', true, 10);
            $tipax_addresses = get_transient('tipax_addresses');
            $data = [];
    
            if ($this->accessToken) {
                $response = $this->request->apiRequest('Addresses', $data, "GET", $this->accessToken);
            }
    
            $allAddresses = [];
            if (isset($response[0])) {
                foreach ($response as $address) {
                    if ($address->isDefault) {
                        $user = isset($this->settings["username"]) ? $this->settings["username"] : null;
                        if($address->creator == $user){
                            if(isset($address->modifier) && $address->modifier == $user){
                                $tipax_addresses = $address;
                            } else if(!isset($address->modifier)){
                                $tipax_addresses = $address;
                            }
                        }
                    }
                    $allAddresses[$address->id]['originId'] = $address->addressesId;
                    $allAddresses[$address->id]['fullAddress'] = $address;
                }
            }
    
            // Save presence status
            if (!empty($response) && isset($tipax_addresses->address)) {
                update_option('tipax_has_address', 'yes');
            } else {
                update_option('tipax_has_address', 'no');
            }
    
            set_transient('tipax_addresses', $tipax_addresses, 12 * HOUR_IN_SECONDS);
    
            $addresses_objects = $tipax_addresses;
            $dataAddr = [];
    
            if (get_option('tipax_shipping_address') !== false) {
                $originIdToCheck = get_option('tipax_shipping_address');
            } else {
                $originIdToCheck = null;
            }
    
            if (count($allAddresses) > 0) {
                $exists = false;
    
                foreach ($allAddresses as $object) {
                    if ($object['originId'] == $originIdToCheck) {
                        $exists = true;
                        break;
                    }
                }
                if (!$exists && isset($allAddresses[$addresses_objects->id])) {
                    $originAddressId = $allAddresses[$addresses_objects->id]['originId'];
                    if (get_option('tipax_shipping_address') !== false) {
                        update_option('tipax_shipping_address', $originAddressId, '', 'yes');
                    } else {
                        add_option('tipax_shipping_address', $originAddressId, '', 'yes');
                    }
                    delete_transient('tipax_addresses');
                    set_transient('tipax_addresses', $allAddresses[$addresses_objects->id]['fullAddress'], 12 * HOUR_IN_SECONDS);
                }
            }
        }
        tipax_log('Your new AddressId is :'.get_option('tipax_shipping_address'));
        $tipax_addresses = get_transient('tipax_addresses');
    
        // Fallback fetch if no cache or invalid
        if ($tipax_addresses === false || !isset($tipax_addresses->address)) {
            $data = [];
            if ($this->accessToken) {
                $response = $this->request->apiRequest('Addresses', $data, "GET", $this->accessToken);
            }
    
            if (isset($response[0])) {
                foreach ($response as $address) {
                    if ($address->isDefault) {
                        $tipax_addresses = $address;
                    }
                }
            }
    
            // ✅ Update status again here
            if (!empty($response) && isset($tipax_addresses->address)) {
                update_option('tipax_has_address', 'yes');
            } else {
                update_option('tipax_has_address', 'no');
            }
    
            set_transient('tipax_addresses', $tipax_addresses, 12 * HOUR_IN_SECONDS);
        }
    
        return $tipax_addresses;
    }

}
