<?php
class Tipax_Logger {
    private static $instance = null;
    private $log_file;
    private $log_dir;
    private $max_file_size = 1048576; // 1MB in bytes
    
    private function __construct() {
        $this->log_dir = plugin_dir_path(__FILE__) . '../../logs/';
        $this->log_file = $this->log_dir . 'tipax_shipping.log';
        // Create logs directory if it doesn't exist
        if (!file_exists($this->log_dir)) {
            wp_mkdir_p($this->log_dir);
        }
    }
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    public function log($message, $level = 'INFO') {
        $timestamp = current_time('mysql');
        $log_entry = "[{$timestamp}] [{$level}] {$message}\n";
        
        // Rotate log file if it's too big
        if (file_exists($this->log_file)) {
            $filesize = filesize($this->log_file);
            if ($filesize > $this->max_file_size) {
                $this->rotate_logs();
            }
        }
        
        file_put_contents($this->log_file, $log_entry, FILE_APPEND | LOCK_EX);
    }
    
    private function rotate_logs() {
        $backup_file = $this->log_dir . 'tipax_shipping_' . date('Y-m-d_H-i-s') . '.log';
        rename($this->log_file, $backup_file);
    }
    
    public function get_logs($lines = 100) {
        if (!file_exists($this->log_file)) {
            return array();
        }
        
        $file = file($this->log_file);
        $lines = min($lines, count($file));
        return array_slice($file, -$lines);
    }
    
    public function clear_logs() {
        if (file_exists($this->log_file)) {
            file_put_contents($this->log_file, '');
        }
        return true;
    }
    
    public function get_log_file_path() {
        return $this->log_file;
    }
}

// Helper function to replace error_log()
function tipax_log($message, $level = 'INFO') {
    Tipax_Logger::get_instance()->log($message, $level);
}