<?php
if (!defined('ABSPATH')) {
    exit;
}

class WC_Gateway_Tipax_COD extends WC_Payment_Gateway {
    public function __construct() {
        $this->id = 'tipax_cod';
        $this->method_title = 'Tipax COD';
        $this->method_description = 'پرداخت نقدی مخصوص ارسال با تیپاکس';
        $this->has_fields = false;
        $this->enabled = 'yes';
        $this->title = 'پرداخت نقدی تیپاکس';

        $this->init_form_fields();
        $this->init_settings();

        $this->enabled = $this->get_option('enabled');
        $this->title   = $this->get_option('title');

        add_action('woocommerce_update_options_payment_gateways_' . $this->id, [$this, 'process_admin_options']);
    }

    public function init_form_fields() {
        $this->form_fields = [
            'enabled' => [
                'title'   => 'فعال‌سازی',
                'type'    => 'checkbox',
                'label'   => 'فعال کردن پرداخت نقدی تیپاکس',
                'default' => 'yes'
            ],
            'title' => [
                'title'       => 'عنوان',
                'type'        => 'text',
                'description' => 'عنوان روش پرداخت در هنگام پرداخت.',
                'default'     => 'پرداخت نقدی تیپاکس',
                'desc_tip'    => true,
            ]
        ];
    }


    public function process_payment($order_id) {
        $order = wc_get_order($order_id);
        $order->payment_complete();
        return [
            'result'   => 'success',
            'redirect' => $this->get_return_url($order)
        ];
    }
}
