<?php
add_filter('pre_set_site_transient_update_plugins', 'tipax_check_for_update');
add_filter('plugins_api', 'tipax_plugin_info', 10, 3);

function tipax_check_for_update($transient) {
    if (empty($transient->checked)) {
        return $transient;
    }

    // The JSON file that describes the latest release
    $remote_url = 'https://sabahi.ir/tipax-update.json';

    // Optional: include the site URL for tracking
    $remote_url = add_query_arg('site', urlencode(home_url()), $remote_url);

    $response = wp_remote_get($remote_url, [
        'timeout' => 10,
        'headers' => ['Accept' => 'application/json']
    ]);

    if (is_wp_error($response)) {
        return $transient;
    }

    $remote = json_decode(wp_remote_retrieve_body($response));
    if (!$remote || empty($remote->version)) {
        return $transient;
    }

    // Correct plugin file (important!)
    $plugin_file = 'delivery-services-tipax-shipping/delivery-services-tipax-shipping.php';
    $current_version = $transient->checked[$plugin_file] ?? null;

    if ($current_version && version_compare($remote->version, $current_version, '>')) {
        $obj = new stdClass();
        $obj->slug = 'delivery-services-tipax-shipping';
        $obj->plugin = $plugin_file;
        $obj->new_version = $remote->version;
        $obj->url = $remote->homepage ?? '';
        $obj->package = $remote->download_url;
        $obj->tested = $remote->tested ?? '';
        $obj->requires = $remote->requires ?? '';

        $transient->response[$plugin_file] = $obj;
    }

    return $transient;
}

function tipax_plugin_info($res, $action, $args) {
    // Match correct slug here too
    if ($action !== 'plugin_information' || $args->slug !== 'delivery-services-tipax-shipping') {
        return $res;
    }

    $remote_url = 'https://sabahi.ir/tipax-update.json';
    $response = wp_remote_get($remote_url);

    if (is_wp_error($response)) {
        return $res;
    }

    $remote = json_decode(wp_remote_retrieve_body($response));
    if (!$remote) {
        return $res;
    }

    $res = new stdClass();
    $res->name = $remote->name ?? 'Tipax Shipping';
    $res->slug = 'delivery-services-tipax-shipping';
    $res->version = $remote->version;
    $res->author = $remote->author ?? 'Alireza Sabahi';
    $res->homepage = $remote->homepage ?? 'https://plugintheme.org';
    $res->download_link = $remote->download_url;
    $res->sections = (array) ($remote->sections ?? ['description' => 'No description.']);

    return $res;
}
?>
