<?php
add_filter('woocommerce_payment_gateways', function ($methods) {
    $methods[] = 'WC_Gateway_Tipax_COD';
    return $methods;
});


add_filter('woocommerce_available_payment_gateways', 'tipax_filter_cod_payment_gateway');

function tipax_filter_cod_payment_gateway($available_gateways) {
    
    $option_key = 'woocommerce_tipax_shipping_method_settings';
    $settings = get_option($option_key, []);
    if($settings['checkout_method'] == 30){
        if (!is_admin() && is_checkout()) {
            $chosen_methods = WC()->session->get('chosen_shipping_methods');
            $chosen_method = is_array($chosen_methods) ? reset($chosen_methods) : '';
    
            $is_tipax = $chosen_method && strpos($chosen_method, 'tipax_shipping_method') !== false;
            $shipping_total = floatval(WC()->cart->get_shipping_total());
    
            if ($is_tipax && $shipping_total > 0) {
                // Only keep Tipax COD
                foreach ($available_gateways as $id => $gateway) {
                    if ($id !== 'tipax_cod') {
                        unset($available_gateways[$id]);
                    }
                }
            } else {
                // Remove Tipax COD
                unset($available_gateways['tipax_cod']);
            }
        }
    }

    return $available_gateways;
}

add_action('wp_footer', 'tipax_cod_checkout_script');
function tipax_cod_checkout_script() {
    if (is_checkout()) {
        // Get Tipax checkout method from settings
        $settings = get_option('woocommerce_tipax_shipping_method_settings', []);
        $checkout_method = isset($settings['checkout_method']) ? intval($settings['checkout_method']) : 0;

        ?>
        <script>
        jQuery(function($) {
            function maybeToggleCOD() {
                let tipaxSelected = false;
                let shippingCost = 0;
                let checkoutMethod = <?php echo (int) $checkout_method; ?>;

                $('input[name^="shipping_method"]').each(function() {
                    if ($(this).is(':checked') && $(this).val().includes('tipax_shipping_method')) {
                        tipaxSelected = true;
                        let costText = $(this).next('label').find('.woocommerce-Price-amount').text().replace(/[^0-9.]/g, '');
                        shippingCost = parseFloat(costText) || 0;
                    }
                });

                if (tipaxSelected && shippingCost > 0 && checkoutMethod === 30) {
                    $('.payment_method_tipax_cod').show();
                } else {
                    $('input#payment_method_tipax_cod').prop('checked', false);
                    $('.payment_method_tipax_cod').hide();
                }
            }

            $(document.body).on('updated_checkout updated_shipping_method', maybeToggleCOD);
            maybeToggleCOD();
        });
        </script>
        <?php
    }
}

